/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.type;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.BulkDataWriter;
import dev.xkmc.fastprojectileapi.render.core.DanmakuRenderStates;
import dev.xkmc.fastprojectileapi.render.core.DisplayType;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import dev.xkmc.fastprojectileapi.render.type.RenderableProjectileType;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public record DoubleLayerLaserType(ResourceLocation inner, ResourceLocation outer, int color) implements RenderableProjectileType<DoubleLayerLaserType, Ins>
{
    @Override
    public int order() {
        return 10;
    }

    @Override
    public void start(MultiBufferSource buffer, List<Ins> list) {
        boolean additive = (Boolean)YHModConfig.CLIENT.laserRenderAdditive.get();
        boolean invert = (Boolean)YHModConfig.CLIENT.laserRenderInverted.get();
        int n = list.size() * 4;
        int count = 1;
        if (invert || !additive) {
            ++count;
        }
        BulkDataWriter vc = new BulkDataWriter(buffer.m_6299_(DanmakuRenderStates.laser(this.inner, DisplayType.TRANSPARENT)), n * count);
        for (Ins e : list) {
            e.texInner(vc, e.core);
        }
        if (invert || !additive) {
            for (Ins e : list) {
                e.texOuter(invert, vc, e.tran);
            }
        }
        vc.flush();
        if (additive) {
            vc = new BulkDataWriter(buffer.m_6299_(DanmakuRenderStates.laser(this.outer, DisplayType.ADDITIVE)), n);
            for (Ins e : list) {
                e.texOuter(false, vc, e.add);
            }
            vc.flush();
        }
    }

    @Override
    public void create(Consumer<Ins> holder, ProjectileRenderer<?> r, SimplifiedProjectile e, PoseStack pose, float pTick) {
        double fade = r.fading(e);
        double tran = fade * (Double)YHModConfig.CLIENT.laserTransparency.get();
        int core = (int)(fade * 255.0) << 24 | 0xFFFFFF;
        int outer = (int)(tran * 255.0) << 24 | this.color & 0xFFFFFF;
        int add = (int)((double)(this.color & 0xFF) * tran) | (int)((double)(this.color >> 8 & 0xFF) * tran) << 8 | (int)((double)(this.color >> 16 & 0xFF) * tran) << 16 | 0xFF000000;
        Cache data = Cache.vertex(pose.m_85850_().m_252922_(), 0.167f, 0.5f);
        holder.accept(new Ins(data, core, outer, add));
    }

    public record Ins(Cache cache, int core, int tran, int add) {
        public void texInner(BulkDataWriter vc, int color) {
            this.renderPart(false, vc, color, this.cache.r0);
        }

        public void texOuter(boolean invert, BulkDataWriter vc, int color) {
            this.renderPart(invert, vc, color, this.cache.r1);
        }

        private void renderPart(boolean invert, BulkDataWriter vc, int color, float[][] arr) {
            this.renderQuad(invert, vc, color, arr, 0, 2);
            this.renderQuad(invert, vc, color, arr, 3, 1);
            this.renderQuad(invert, vc, color, arr, 2, 3);
            this.renderQuad(invert, vc, color, arr, 1, 0);
        }

        private void renderQuad(boolean invert, BulkDataWriter vc, int col, float[][] arr, int i0, int i1) {
            if (invert) {
                this.addVertex(vc, col, arr[i1 + 4], 0.0f, 0.0f);
                this.addVertex(vc, col, arr[i1], 0.0f, 1.0f);
                this.addVertex(vc, col, arr[i0], 1.0f, 1.0f);
                this.addVertex(vc, col, arr[i0 + 4], 1.0f, 0.0f);
            } else {
                this.addVertex(vc, col, arr[i0 + 4], 1.0f, 0.0f);
                this.addVertex(vc, col, arr[i0], 1.0f, 1.0f);
                this.addVertex(vc, col, arr[i1], 0.0f, 1.0f);
                this.addVertex(vc, col, arr[i1 + 4], 0.0f, 0.0f);
            }
        }

        private void addVertex(BulkDataWriter vc, int col, float[] arr, float u, float v) {
            vc.addVertex(arr[0], arr[1], arr[2], u, v, col);
        }
    }

    public record Cache(float[][] r0, float[][] r1) {
        private static Cache vertex(Matrix4f mat, float s0, float s1) {
            Vector4f p0 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)mat);
            Vector4f px = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f).mul((Matrix4fc)mat);
            Vector4f py = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f).mul((Matrix4fc)mat);
            Vector4f pz = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f).mul((Matrix4fc)mat);
            Cache ans = new Cache(new float[8][3], new float[8][3]);
            Cache.fill(ans.r0, p0, px, py, pz, s0);
            Cache.fill(ans.r1, p0, px, py, pz, s1);
            return ans;
        }

        private static void fill(float[][] arr, Vector4f p0, Vector4f px, Vector4f py, Vector4f pz, float scale) {
            Cache.calc(arr[0], p0, px, pz, -scale, -scale);
            Cache.calc(arr[1], p0, px, pz, scale, -scale);
            Cache.calc(arr[2], p0, px, pz, -scale, scale);
            Cache.calc(arr[3], p0, px, pz, scale, scale);
            Cache.add(arr[4], arr[0], py);
            Cache.add(arr[5], arr[1], py);
            Cache.add(arr[6], arr[2], py);
            Cache.add(arr[7], arr[3], py);
        }

        private static void calc(float[] arr, Vector4f p0, Vector4f px, Vector4f pz, float sx, float sz) {
            arr[0] = p0.x + px.x * sx + pz.x * sz;
            arr[1] = p0.y + px.y * sx + pz.y * sz;
            arr[2] = p0.z + px.z * sx + pz.z * sz;
        }

        private static void add(float[] arr, float[] base, Vector4f p) {
            arr[0] = base[0] + p.x;
            arr[1] = base[1] + p.y;
            arr[2] = base[2] + p.z;
        }
    }
}

